@echo off
setlocal

for /f %%i in ('powershell -Command "Get-Date -Format yyyy-MM-dd_HH-mm-ss"') do set timestamp=%%i
set "baseDir=C:\ProgramData\AnF\TeamViewer"
set "logDir=%baseDir%\Logs"
set "scriptLog=%logDir%\TV_Host_Install_%timestamp%_script.log"
set "msiLog=%logDir%\TV_Host_Install_%timestamp%_msi.log"
set "tagFilePath=%baseDir%\TV_Host_Batch_Installed.txt"
set "tvExeHostPath=C:\Program Files\TeamViewer\TeamViewer.exe"

mkdir "%logDir%" 2>nul

echo === TeamViewer Host Install Started ===
echo Setting Conditional Access Servers... >> "%scriptLog%"
echo Setting Conditional Access Servers...
reg add "HKLM\SOFTWARE\TeamViewer" /f
reg add "HKLM\SOFTWARE\TeamViewer" /v "ConditionalAccessServers" /t REG_MULTI_SZ /d "us-atl-anx-c021.carouter.teamviewer.com\0us-chi-anx-c013.carouter.teamviewer.com\0us-was-anx-c003.carouter.teamviewer.com" /f

echo Installing TeamViewer Host MSI... >> "%scriptLog%"
echo Installing TeamViewer Host MSI...
start /wait msiexec.exe /i "%~dp0TeamViewer_Host.msi" /qn CUSTOMCONFIGID=6nivbhe DesktopShortcuts=0 /L*v "%msiLog%"
if %ERRORLEVEL% NEQ 0 echo ERROR: MSI install failed with code %ERRORLEVEL%. >> "%scriptLog%"
echo Waiting 30 seconds after install... >> "%scriptLog%"
timeout /t 30 /nobreak >nul

echo Registering device... >> "%scriptLog%"
echo Registering device...
powershell.exe -ExecutionPolicy Bypass -File "%~dp0TVAct_Assignment.ps1"
if %ERRORLEVEL% NEQ 0 echo ERROR: Assignment script failed with code %ERRORLEVEL%. >> "%scriptLog%"
echo Waiting 15 seconds after assignment... >> "%scriptLog%"
timeout /t 15 /nobreak >nul

echo Verifying installation... >> "%scriptLog%"
echo Verifying installation...
if exist "%tvExeHostPath%" (
    for /f "tokens=*" %%P in ('powershell -Command "(Get-Item ''%tvExeHostPath%'').VersionInfo.ProductName"') do (
        echo Detected ProductName: %%P >> "%scriptLog%"
        echo %%P | findstr /i /c:"TeamViewer Host" >nul
        if %ERRORLEVEL%==0 (
            echo Creating tag file... >> "%scriptLog%"
            echo Installed > "%tagFilePath%"
            echo === Install Verified === >> "%scriptLog%"
        ) else (
            echo ProductName mismatch. Tag file not created. TeamViewer Host installation failed. >> "%scriptLog%"
            echo ProductName mismatch. Tag file not created. TeamViewer Host installation failed.
            exit /b 1
        )
    )
) else (
    echo TeamViewer.exe not found. Tag file not created. TeamViewer Host installation failed.>> "%scriptLog%"
    echo TeamViewer.exe not found. Tag file not created. TeamViewer Host installation failed.
    exit /b 1
)

echo Output to CEE/CES channel === > "%scriptLog%"
echo Output to CEE/CES channel
powershell.exe -ExecutionPolicy Bypass -File "%~dp0TVAct_Webhook.ps1"

echo Launching TeamViewer Host... >> "%scriptLog%"
echo Launching TeamViewer Host...
start "" "%tvExeHostPath%"

echo === TeamViewer Host Install Finished ===
endlocal
pause
exit /b 0
